<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\ReservationController;
use App\Http\Controllers\Admin\FloorplanController;
use App\Models\Reservation;

Route::middleware(['auth'])->group(function () {
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('/floorplans', [FloorplanController::class, 'index'])->name('floorplans.index');
        Route::post('/floorplans', [FloorplanController::class, 'store'])->name('floorplans.store');
        Route::get('/floorplans/{floorplan}', [FloorplanController::class, 'show'])->name('floorplans.show');

        Route::post('/floorplans/{floorplan}/tables', [FloorplanController::class, 'createTable'])->name('floorplans.tables.create');
        Route::put('/tables/{table}', [FloorplanController::class, 'updateTable'])->name('tables.update');
    });
});

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/lang/{locale}', function (string $locale) {
    $supported = ['en', 'bg'];
    if (!in_array($locale, $supported, true)) {
        $locale = 'bg';
    }
    session(['locale' => $locale]);
    return redirect()->back();
})->name('lang.switch');

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
Route::post('/admin/floorplans/{floorplan}/tables/assign-waiter', [\App\Http\Controllers\Admin\FloorplanController::class, 'assignWaiter'])
    ->middleware('auth')
    ->name('admin.floorplans.tables.assignWaiter');

Route::middleware(['auth'])->group(function () {

    // Admin (SuperAdmin only)
    Route::prefix('admin')->name('admin.')->group(function () {
        Route::get('/users', [UserController::class, 'index'])->name('users.index');
        Route::post('/users', [UserController::class, 'store'])->name('users.store');
        Route::post('/reservations/{reservation}/sync-tables', [FloorplanController::class, 'syncReservationTables'])
    ->name('reservations.tables.sync');
    });
Route::post('/reservations/{reservation}/toggle-seated', [ReservationController::class, 'toggleSeated'])
    ->middleware('auth')
    ->name('reservations.toggleSeated');
    
    // Reservations (everyone logged-in; policy handles move/edit rules)
    Route::get('/reservations', [ReservationController::class, 'index'])->name('reservations.index');
    Route::post('/reservations', [ReservationController::class, 'store'])->name('reservations.store');
    Route::get('/reservations/{reservation}/edit', [ReservationController::class, 'edit'])->name('reservations.edit');
    Route::put('/reservations/{reservation}', [ReservationController::class, 'update'])->name('reservations.update');
    Route::post('/reservations/{reservation}/tables', [ReservationController::class, 'updateTables'])->name('reservations.tables.update');
    Route::post('/reservations/{reservation}/lock-move', [ReservationController::class, 'toggleLockMove'])->name('reservations.lockmove');

});
require __DIR__.'/auth.php';
