<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('app.users') }}
            </h2>

            <div class="flex items-center gap-3">
                <span class="text-sm text-gray-600">{{ __('app.language') }}:</span>
                <a class="underline text-sm" href="{{ route('lang.switch','bg') }}">BG</a>
                <a class="underline text-sm" href="{{ route('lang.switch','en') }}">EN</a>
            </div>
        </div>
    </x-slot>

    <div class="py-6 max-w-7xl mx-auto sm:px-6 lg:px-8">
        @if (session('status'))
            <div class="mb-4 p-3 bg-green-50 border border-green-200 rounded">
                {{ session('status') }}
            </div>
        @endif

        <div class="bg-white shadow sm:rounded-lg p-6 mb-6">
            <h3 class="text-lg font-semibold mb-4">{{ __('app.create_user') }}</h3>

            <form method="POST" action="{{ route('admin.users.store') }}" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @csrf

                <div>
                    <label class="block text-sm mb-1">{{ __('app.name') }}</label>
                    <input name="name" class="w-full border rounded p-2" required />
                    @error('name') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
                </div>

                <div>
                    <label class="block text-sm mb-1">{{ __('app.email') }}</label>
                    <input name="email" type="email" class="w-full border rounded p-2" required />
                    @error('email') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
                </div>

                <div>
                    <label class="block text-sm mb-1">{{ __('app.password') }}</label>
                    <input name="password" type="password" class="w-full border rounded p-2" required />
                    @error('password') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
                </div>

                <div>
                    <label class="block text-sm mb-1">{{ __('app.role') }}</label>
                    <select name="role" class="w-full border rounded p-2" required>
                        <option value="Manager">Manager / Управител</option>
                        <option value="Hostess">Hostess / Хостеса</option>
                        <option value="Waiter">Waiter / Сервитьор</option>
                        <option value="SuperAdmin">SuperAdmin</option>
                    </select>
                    @error('role') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
                </div>

                <div class="md:col-span-2">
                    <button class="px-4 py-2 rounded bg-black text-white">
                        {{ __('app.save') }}
                    </button>
                </div>
            </form>
        </div>

        <div class="bg-white shadow sm:rounded-lg p-6">
            <h3 class="text-lg font-semibold mb-4">{{ __('app.users') }}</h3>

            <div class="overflow-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="py-2 pr-4">ID</th>
                            <th class="py-2 pr-4">{{ __('app.name') }}</th>
                            <th class="py-2 pr-4">{{ __('app.email') }}</th>
                            <th class="py-2 pr-4">{{ __('app.role') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $u)
                            <tr class="border-b">
                                <td class="py-2 pr-4">{{ $u->id }}</td>
                                <td class="py-2 pr-4">{{ $u->name }}</td>
                                <td class="py-2 pr-4">{{ $u->email }}</td>
                                <td class="py-2 pr-4">{{ $u->roles->pluck('name')->join(', ') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</x-app-layout>
