<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                Floorplans
            </h2>
            <div class="flex items-center gap-3">
                <a class="underline text-sm" href="{{ route('lang.switch','bg') }}">BG</a>
                <a class="underline text-sm" href="{{ route('lang.switch','en') }}">EN</a>
            </div>
        </div>
    </x-slot>

    <div class="py-6 max-w-6xl mx-auto sm:px-6 lg:px-8">
        @if (session('status'))
            <div class="mb-4 p-3 bg-green-50 border border-green-200 rounded">
                {{ session('status') }}
            </div>
        @endif

        <div class="bg-white shadow sm:rounded-lg p-6 mb-6">
            <h3 class="text-lg font-semibold mb-4">Upload new floorplan</h3>

            <form method="POST" action="{{ route('admin.floorplans.store') }}" enctype="multipart/form-data" class="grid grid-cols-1 md:grid-cols-2 gap-4">
                @csrf
                <div>
                    <label class="block text-sm mb-1">Name</label>
                    <input name="name" class="w-full border rounded p-2" required>
                    @error('name') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
                </div>

                <div>
                    <label class="block text-sm mb-1">Image (PNG/JPG)</label>
                    <input type="file" name="image" class="w-full border rounded p-2" required>
                    @error('image') <div class="text-red-600 text-sm">{{ $message }}</div> @enderror
                </div>

                <div class="md:col-span-2">
                    <button class="px-4 py-2 rounded bg-black text-white">Upload</button>
                </div>
            </form>
        </div>

        <div class="bg-white shadow sm:rounded-lg p-6">
            <h3 class="text-lg font-semibold mb-4">Existing floorplans</h3>

            <ul class="list-disc pl-5">
                @forelse($floorplans as $fp)
                    <li class="mb-2">
                        <a class="underline" href="{{ route('admin.floorplans.show', $fp) }}">
                            {{ $fp->name }} (ID {{ $fp->id }})
                        </a>
                    </li>
                @empty
                    <li>No floorplans yet.</li>
                @endforelse
            </ul>
        </div>
    </div>
</x-app-layout>
