<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('tables', function (Blueprint $table) {
            if (!Schema::hasColumn('tables', 'waiter_team')) {
                $table->string('waiter_team', 50)->nullable()->after('rotation');
            }
            if (!Schema::hasColumn('tables', 'waiter_color')) {
                $table->string('waiter_color', 20)->nullable()->after('waiter_team'); // e.g. "#ff00aa"
            }
        });
    }

    public function down(): void
    {
        Schema::table('tables', function (Blueprint $table) {
            if (Schema::hasColumn('tables', 'waiter_color')) $table->dropColumn('waiter_color');
            if (Schema::hasColumn('tables', 'waiter_team')) $table->dropColumn('waiter_team');
        });
    }
};
