<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('floorplans', function (Blueprint $table) {
            $table->string('default_view')->default('reservations'); // reservations|waiter
            $table->json('settings_json')->nullable();
        });

        Schema::table('tables', function (Blueprint $table) {
            $table->string('display_label')->nullable();
            $table->json('meta_json')->nullable(); // what to show inside, per-role hints, etc.
        });
    }

    public function down(): void
    {
        Schema::table('floorplans', function (Blueprint $table) {
            $table->dropColumn(['default_view','settings_json']);
        });

        Schema::table('tables', function (Blueprint $table) {
            $table->dropColumn(['display_label','meta_json']);
        });
    }
};
