<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('reservations', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();

            $table->string('guest_name');
            $table->string('phone')->nullable();

            $table->unsignedInteger('people_count')->default(2);
            $table->date('date'); // reservation date
            $table->time('expected_arrival_time')->nullable();

            $table->decimal('advance_amount', 10, 2)->default(0);
            $table->text('notes')->nullable();

            $table->enum('status', ['pending','confirmed','arrived','no_show','cancelled'])
                ->default('pending');

            // who created it
            $table->foreignId('created_by_user_id')->constrained('users')->cascadeOnDelete();

            // DO NOT MOVE logic:
            $table->boolean('locked_move')->default(false);
            $table->foreignId('locked_by_user_id')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();

            $table->index(['date', 'status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('reservations');
    }
};
