<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('tables', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->id();
            $table->foreignId('floorplan_id')->constrained()->cascadeOnDelete();

            $table->string('label'); // e.g. "T1", "VIP-3"
            $table->enum('shape', ['rect_lg','rect_sm','sq_lg','sq_sm','circle_lg','circle_sm']);
            $table->unsignedInteger('seats')->default(4);

            // Positioning on the floorplan canvas (px)
            $table->integer('x')->default(0);
            $table->integer('y')->default(0);
            $table->unsignedInteger('w')->default(60);
            $table->unsignedInteger('h')->default(60);
            $table->integer('rotation')->default(0);

            $table->boolean('is_active')->default(true);

            // For hostess “Настанени” toggle later (per night this becomes more complex,
            // but for MVP we store a simple live state)
            $table->enum('live_status', ['free','reserved','seated'])->default('free');

            $table->timestamps();

            $table->unique(['floorplan_id', 'label']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tables');
    }
};
