<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Table extends Model
{
    protected $fillable = [
        'floorplan_id',
        'label',
        'display_label',
        'shape',
        'seats',
        'x',
        'y',
        'w',
        'h',
        'rotation',
        'is_active',
        'live_status',
        'meta_json',
        'waiter_team',
        'waiter_color',
    ];

    protected $casts = [
        'meta_json' => 'array',
    ];

    public function floorplan(): BelongsTo
    {
        return $this->belongsTo(Floorplan::class);
    }

    public function reservations(): BelongsToMany
    {
        return $this->belongsToMany(Reservation::class, 'reservation_table')->withTimestamps();
    }
}
