<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Reservation extends Model
{
    protected $fillable = [
        'guest_name','phone','people_count','date','expected_arrival_time',
        'advance_amount','notes','status',
        'created_by_user_id','locked_move','locked_by_user_id'
    ];

    protected $casts = [
        'date' => 'date',
        'locked_move' => 'boolean',
        'advance_amount' => 'decimal:2',
    ];

    public function tables(): BelongsToMany
    {
        return $this->belongsToMany(Table::class, 'reservation_table')->withTimestamps();
    }

    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by_user_id');
    }

    public function lockedBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'locked_by_user_id');
    }
}
