<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Floorplan extends Model
{
    protected $fillable = ['name', 'image_path', 'width', 'height', 'default_view', 'settings_json'];

    protected $casts = [
        'settings_json' => 'array',
    ];

    public function tables(): HasMany
    {
        return $this->hasMany(Table::class);
    }
}
